// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> All security rules associated with the network interface. </summary>
    public partial class SecurityRuleAssociations
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityRuleAssociations"/>. </summary>
        internal SecurityRuleAssociations()
        {
            DefaultSecurityRules = new ChangeTrackingList<SecurityRuleData>();
            EffectiveSecurityRules = new ChangeTrackingList<EffectiveNetworkSecurityRule>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityRuleAssociations"/>. </summary>
        /// <param name="networkInterfaceAssociation"> Network interface and it's custom security rules. </param>
        /// <param name="subnetAssociation"> Subnet and it's custom security rules. </param>
        /// <param name="defaultSecurityRules"> Collection of default security rules of the network security group. </param>
        /// <param name="effectiveSecurityRules"> Collection of effective security rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityRuleAssociations(NetworkInterfaceAssociation networkInterfaceAssociation, SubnetAssociation subnetAssociation, IReadOnlyList<SecurityRuleData> defaultSecurityRules, IReadOnlyList<EffectiveNetworkSecurityRule> effectiveSecurityRules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkInterfaceAssociation = networkInterfaceAssociation;
            SubnetAssociation = subnetAssociation;
            DefaultSecurityRules = defaultSecurityRules;
            EffectiveSecurityRules = effectiveSecurityRules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Network interface and it's custom security rules. </summary>
        public NetworkInterfaceAssociation NetworkInterfaceAssociation { get; }
        /// <summary> Subnet and it's custom security rules. </summary>
        public SubnetAssociation SubnetAssociation { get; }
        /// <summary> Collection of default security rules of the network security group. </summary>
        public IReadOnlyList<SecurityRuleData> DefaultSecurityRules { get; }
        /// <summary> Collection of effective security rules. </summary>
        public IReadOnlyList<EffectiveNetworkSecurityRule> EffectiveSecurityRules { get; }
    }
}
