// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The Security Providers. </summary>
    public readonly partial struct SecurityProviderName : IEquatable<SecurityProviderName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityProviderName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityProviderName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ZScalerValue = "ZScaler";
        private const string IBossValue = "IBoss";
        private const string CheckpointValue = "Checkpoint";

        /// <summary> ZScaler. </summary>
        public static SecurityProviderName ZScaler { get; } = new SecurityProviderName(ZScalerValue);
        /// <summary> IBoss. </summary>
        public static SecurityProviderName IBoss { get; } = new SecurityProviderName(IBossValue);
        /// <summary> Checkpoint. </summary>
        public static SecurityProviderName Checkpoint { get; } = new SecurityProviderName(CheckpointValue);
        /// <summary> Determines if two <see cref="SecurityProviderName"/> values are the same. </summary>
        public static bool operator ==(SecurityProviderName left, SecurityProviderName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityProviderName"/> values are not the same. </summary>
        public static bool operator !=(SecurityProviderName left, SecurityProviderName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityProviderName"/>. </summary>
        public static implicit operator SecurityProviderName(string value) => new SecurityProviderName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityProviderName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityProviderName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
