// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The current state of the connection with Security Partner Provider. </summary>
    public readonly partial struct SecurityPartnerProviderConnectionStatus : IEquatable<SecurityPartnerProviderConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityPartnerProviderConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityPartnerProviderConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PartiallyConnectedValue = "PartiallyConnected";
        private const string ConnectedValue = "Connected";
        private const string NotConnectedValue = "NotConnected";

        /// <summary> Unknown. </summary>
        public static SecurityPartnerProviderConnectionStatus Unknown { get; } = new SecurityPartnerProviderConnectionStatus(UnknownValue);
        /// <summary> PartiallyConnected. </summary>
        public static SecurityPartnerProviderConnectionStatus PartiallyConnected { get; } = new SecurityPartnerProviderConnectionStatus(PartiallyConnectedValue);
        /// <summary> Connected. </summary>
        public static SecurityPartnerProviderConnectionStatus Connected { get; } = new SecurityPartnerProviderConnectionStatus(ConnectedValue);
        /// <summary> NotConnected. </summary>
        public static SecurityPartnerProviderConnectionStatus NotConnected { get; } = new SecurityPartnerProviderConnectionStatus(NotConnectedValue);
        /// <summary> Determines if two <see cref="SecurityPartnerProviderConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(SecurityPartnerProviderConnectionStatus left, SecurityPartnerProviderConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityPartnerProviderConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(SecurityPartnerProviderConnectionStatus left, SecurityPartnerProviderConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityPartnerProviderConnectionStatus"/>. </summary>
        public static implicit operator SecurityPartnerProviderConnectionStatus(string value) => new SecurityPartnerProviderConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityPartnerProviderConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityPartnerProviderConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
