// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The information about security rules applied to the specified VM. </summary>
    public partial class SecurityGroupViewResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityGroupViewResult"/>. </summary>
        internal SecurityGroupViewResult()
        {
            NetworkInterfaces = new ChangeTrackingList<SecurityGroupNetworkInterface>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityGroupViewResult"/>. </summary>
        /// <param name="networkInterfaces"> List of network interfaces on the specified VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityGroupViewResult(IReadOnlyList<SecurityGroupNetworkInterface> networkInterfaces, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkInterfaces = networkInterfaces;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of network interfaces on the specified VM. </summary>
        public IReadOnlyList<SecurityGroupNetworkInterface> NetworkInterfaces { get; }
    }
}
