// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network protocol this rule applies to. </summary>
    public readonly partial struct SecurityConfigurationRuleProtocol : IEquatable<SecurityConfigurationRuleProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityConfigurationRuleProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityConfigurationRuleProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "Tcp";
        private const string UdpValue = "Udp";
        private const string IcmpValue = "Icmp";
        private const string EspValue = "Esp";
        private const string AnyValue = "Any";
        private const string AhValue = "Ah";

        /// <summary> Tcp. </summary>
        public static SecurityConfigurationRuleProtocol Tcp { get; } = new SecurityConfigurationRuleProtocol(TcpValue);
        /// <summary> Udp. </summary>
        public static SecurityConfigurationRuleProtocol Udp { get; } = new SecurityConfigurationRuleProtocol(UdpValue);
        /// <summary> Icmp. </summary>
        public static SecurityConfigurationRuleProtocol Icmp { get; } = new SecurityConfigurationRuleProtocol(IcmpValue);
        /// <summary> Esp. </summary>
        public static SecurityConfigurationRuleProtocol Esp { get; } = new SecurityConfigurationRuleProtocol(EspValue);
        /// <summary> Any. </summary>
        public static SecurityConfigurationRuleProtocol Any { get; } = new SecurityConfigurationRuleProtocol(AnyValue);
        /// <summary> Ah. </summary>
        public static SecurityConfigurationRuleProtocol Ah { get; } = new SecurityConfigurationRuleProtocol(AhValue);
        /// <summary> Determines if two <see cref="SecurityConfigurationRuleProtocol"/> values are the same. </summary>
        public static bool operator ==(SecurityConfigurationRuleProtocol left, SecurityConfigurationRuleProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityConfigurationRuleProtocol"/> values are not the same. </summary>
        public static bool operator !=(SecurityConfigurationRuleProtocol left, SecurityConfigurationRuleProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityConfigurationRuleProtocol"/>. </summary>
        public static implicit operator SecurityConfigurationRuleProtocol(string value) => new SecurityConfigurationRuleProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityConfigurationRuleProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityConfigurationRuleProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
