// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The direction of the rule. The direction specifies if the rule will be evaluated on incoming or outgoing traffic. </summary>
    public readonly partial struct SecurityConfigurationRuleDirection : IEquatable<SecurityConfigurationRuleDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityConfigurationRuleDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityConfigurationRuleDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InboundValue = "Inbound";
        private const string OutboundValue = "Outbound";

        /// <summary> Inbound. </summary>
        public static SecurityConfigurationRuleDirection Inbound { get; } = new SecurityConfigurationRuleDirection(InboundValue);
        /// <summary> Outbound. </summary>
        public static SecurityConfigurationRuleDirection Outbound { get; } = new SecurityConfigurationRuleDirection(OutboundValue);
        /// <summary> Determines if two <see cref="SecurityConfigurationRuleDirection"/> values are the same. </summary>
        public static bool operator ==(SecurityConfigurationRuleDirection left, SecurityConfigurationRuleDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityConfigurationRuleDirection"/> values are not the same. </summary>
        public static bool operator !=(SecurityConfigurationRuleDirection left, SecurityConfigurationRuleDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityConfigurationRuleDirection"/>. </summary>
        public static implicit operator SecurityConfigurationRuleDirection(string value) => new SecurityConfigurationRuleDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityConfigurationRuleDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityConfigurationRuleDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
