// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Whether network traffic is allowed or denied. </summary>
    public readonly partial struct SecurityConfigurationRuleAccess : IEquatable<SecurityConfigurationRuleAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityConfigurationRuleAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityConfigurationRuleAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";
        private const string AlwaysAllowValue = "AlwaysAllow";

        /// <summary> Allow. </summary>
        public static SecurityConfigurationRuleAccess Allow { get; } = new SecurityConfigurationRuleAccess(AllowValue);
        /// <summary> Deny. </summary>
        public static SecurityConfigurationRuleAccess Deny { get; } = new SecurityConfigurationRuleAccess(DenyValue);
        /// <summary> AlwaysAllow. </summary>
        public static SecurityConfigurationRuleAccess AlwaysAllow { get; } = new SecurityConfigurationRuleAccess(AlwaysAllowValue);
        /// <summary> Determines if two <see cref="SecurityConfigurationRuleAccess"/> values are the same. </summary>
        public static bool operator ==(SecurityConfigurationRuleAccess left, SecurityConfigurationRuleAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityConfigurationRuleAccess"/> values are not the same. </summary>
        public static bool operator !=(SecurityConfigurationRuleAccess left, SecurityConfigurationRuleAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityConfigurationRuleAccess"/>. </summary>
        public static implicit operator SecurityConfigurationRuleAccess(string value) => new SecurityConfigurationRuleAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityConfigurationRuleAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityConfigurationRuleAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
