// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The current routing state of the VirtualHub. </summary>
    public readonly partial struct RoutingState : IEquatable<RoutingState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoutingState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoutingState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ProvisionedValue = "Provisioned";
        private const string ProvisioningValue = "Provisioning";
        private const string FailedValue = "Failed";

        /// <summary> None. </summary>
        public static RoutingState None { get; } = new RoutingState(NoneValue);
        /// <summary> Provisioned. </summary>
        public static RoutingState Provisioned { get; } = new RoutingState(ProvisionedValue);
        /// <summary> Provisioning. </summary>
        public static RoutingState Provisioning { get; } = new RoutingState(ProvisioningValue);
        /// <summary> Failed. </summary>
        public static RoutingState Failed { get; } = new RoutingState(FailedValue);
        /// <summary> Determines if two <see cref="RoutingState"/> values are the same. </summary>
        public static bool operator ==(RoutingState left, RoutingState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoutingState"/> values are not the same. </summary>
        public static bool operator !=(RoutingState left, RoutingState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoutingState"/>. </summary>
        public static implicit operator RoutingState(string value) => new RoutingState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoutingState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoutingState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
