// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Route destination. </summary>
    public partial class RoutingRuleRouteDestination
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoutingRuleRouteDestination"/>. </summary>
        /// <param name="destinationType"> Destination type. </param>
        /// <param name="destinationAddress"> Destination address. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="destinationAddress"/> is null. </exception>
        public RoutingRuleRouteDestination(RoutingRuleDestinationType destinationType, string destinationAddress)
        {
            Argument.AssertNotNull(destinationAddress, nameof(destinationAddress));

            DestinationType = destinationType;
            DestinationAddress = destinationAddress;
        }

        /// <summary> Initializes a new instance of <see cref="RoutingRuleRouteDestination"/>. </summary>
        /// <param name="destinationType"> Destination type. </param>
        /// <param name="destinationAddress"> Destination address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoutingRuleRouteDestination(RoutingRuleDestinationType destinationType, string destinationAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DestinationType = destinationType;
            DestinationAddress = destinationAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RoutingRuleRouteDestination"/> for deserialization. </summary>
        internal RoutingRuleRouteDestination()
        {
        }

        /// <summary> Destination type. </summary>
        public RoutingRuleDestinationType DestinationType { get; set; }
        /// <summary> Destination address. </summary>
        public string DestinationAddress { get; set; }
    }
}
