// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Routing rule next hop type. </summary>
    public readonly partial struct RoutingRuleNextHopType : IEquatable<RoutingRuleNextHopType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoutingRuleNextHopType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoutingRuleNextHopType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InternetValue = "Internet";
        private const string NoNextHopValue = "NoNextHop";
        private const string VirtualApplianceValue = "VirtualAppliance";
        private const string VirtualNetworkGatewayValue = "VirtualNetworkGateway";
        private const string VnetLocalValue = "VnetLocal";

        /// <summary> Internet. </summary>
        public static RoutingRuleNextHopType Internet { get; } = new RoutingRuleNextHopType(InternetValue);
        /// <summary> NoNextHop. </summary>
        public static RoutingRuleNextHopType NoNextHop { get; } = new RoutingRuleNextHopType(NoNextHopValue);
        /// <summary> VirtualAppliance. </summary>
        public static RoutingRuleNextHopType VirtualAppliance { get; } = new RoutingRuleNextHopType(VirtualApplianceValue);
        /// <summary> VirtualNetworkGateway. </summary>
        public static RoutingRuleNextHopType VirtualNetworkGateway { get; } = new RoutingRuleNextHopType(VirtualNetworkGatewayValue);
        /// <summary> VnetLocal. </summary>
        public static RoutingRuleNextHopType VnetLocal { get; } = new RoutingRuleNextHopType(VnetLocalValue);
        /// <summary> Determines if two <see cref="RoutingRuleNextHopType"/> values are the same. </summary>
        public static bool operator ==(RoutingRuleNextHopType left, RoutingRuleNextHopType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoutingRuleNextHopType"/> values are not the same. </summary>
        public static bool operator !=(RoutingRuleNextHopType left, RoutingRuleNextHopType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoutingRuleNextHopType"/>. </summary>
        public static implicit operator RoutingRuleNextHopType(string value) => new RoutingRuleNextHopType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoutingRuleNextHopType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoutingRuleNextHopType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
