// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Next hop. </summary>
    public partial class RoutingRuleNextHop
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoutingRuleNextHop"/>. </summary>
        /// <param name="nextHopType"> Next hop type. </param>
        public RoutingRuleNextHop(RoutingRuleNextHopType nextHopType)
        {
            NextHopType = nextHopType;
        }

        /// <summary> Initializes a new instance of <see cref="RoutingRuleNextHop"/>. </summary>
        /// <param name="nextHopType"> Next hop type. </param>
        /// <param name="nextHopAddress"> Next hop address. Only required if the next hop type is VirtualAppliance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoutingRuleNextHop(RoutingRuleNextHopType nextHopType, string nextHopAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NextHopType = nextHopType;
            NextHopAddress = nextHopAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RoutingRuleNextHop"/> for deserialization. </summary>
        internal RoutingRuleNextHop()
        {
        }

        /// <summary> Next hop type. </summary>
        public RoutingRuleNextHopType NextHopType { get; set; }
        /// <summary> Next hop address. Only required if the next hop type is VirtualAppliance. </summary>
        public string NextHopAddress { get; set; }
    }
}
