// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The routing policy object used in a RoutingIntent resource. </summary>
    public partial class RoutingPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoutingPolicy"/>. </summary>
        /// <param name="name"> The unique name for the routing policy. </param>
        /// <param name="destinations"> List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic). </param>
        /// <param name="nextHop"> The next hop resource id on which this routing policy is applicable to. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="destinations"/> or <paramref name="nextHop"/> is null. </exception>
        public RoutingPolicy(string name, IEnumerable<string> destinations, string nextHop)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(destinations, nameof(destinations));
            Argument.AssertNotNull(nextHop, nameof(nextHop));

            Name = name;
            Destinations = destinations.ToList();
            NextHop = nextHop;
        }

        /// <summary> Initializes a new instance of <see cref="RoutingPolicy"/>. </summary>
        /// <param name="name"> The unique name for the routing policy. </param>
        /// <param name="destinations"> List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic). </param>
        /// <param name="nextHop"> The next hop resource id on which this routing policy is applicable to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoutingPolicy(string name, IList<string> destinations, string nextHop, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Destinations = destinations;
            NextHop = nextHop;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RoutingPolicy"/> for deserialization. </summary>
        internal RoutingPolicy()
        {
        }

        /// <summary> The unique name for the routing policy. </summary>
        public string Name { get; set; }
        /// <summary> List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic). </summary>
        public IList<string> Destinations { get; }
        /// <summary> The next hop resource id on which this routing policy is applicable to. </summary>
        public string NextHop { get; set; }
    }
}
