// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> A RouteMap Rule. </summary>
    public partial class RouteMapRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RouteMapRule"/>. </summary>
        public RouteMapRule()
        {
            MatchCriteria = new ChangeTrackingList<RouteCriterion>();
            Actions = new ChangeTrackingList<RouteMapAction>();
        }

        /// <summary> Initializes a new instance of <see cref="RouteMapRule"/>. </summary>
        /// <param name="name"> The unique name for the rule. </param>
        /// <param name="matchCriteria"> List of matching criterion which will be applied to traffic. </param>
        /// <param name="actions"> List of actions which will be applied on a match. </param>
        /// <param name="nextStepIfMatched"> Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RouteMapRule(string name, IList<RouteCriterion> matchCriteria, IList<RouteMapAction> actions, RouteMapNextStepBehavior? nextStepIfMatched, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            MatchCriteria = matchCriteria;
            Actions = actions;
            NextStepIfMatched = nextStepIfMatched;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The unique name for the rule. </summary>
        public string Name { get; set; }
        /// <summary> List of matching criterion which will be applied to traffic. </summary>
        public IList<RouteCriterion> MatchCriteria { get; }
        /// <summary> List of actions which will be applied on a match. </summary>
        public IList<RouteMapAction> Actions { get; }
        /// <summary> Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'. </summary>
        public RouteMapNextStepBehavior? NextStepIfMatched { get; set; }
    }
}
