// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Match condition to apply RouteMap rules. </summary>
    public readonly partial struct RouteMapMatchCondition : IEquatable<RouteMapMatchCondition>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RouteMapMatchCondition"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RouteMapMatchCondition(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ContainsValue = "Contains";
        private const string EqualsValueValue = "Equals";
        private const string NotContainsValue = "NotContains";
        private const string NotEqualsValue = "NotEquals";

        /// <summary> Unknown. </summary>
        public static RouteMapMatchCondition Unknown { get; } = new RouteMapMatchCondition(UnknownValue);
        /// <summary> Contains. </summary>
        public static RouteMapMatchCondition Contains { get; } = new RouteMapMatchCondition(ContainsValue);
        /// <summary> Equals. </summary>
        public static RouteMapMatchCondition EqualsValue { get; } = new RouteMapMatchCondition(EqualsValueValue);
        /// <summary> NotContains. </summary>
        public static RouteMapMatchCondition NotContains { get; } = new RouteMapMatchCondition(NotContainsValue);
        /// <summary> NotEquals. </summary>
        public static RouteMapMatchCondition NotEquals { get; } = new RouteMapMatchCondition(NotEqualsValue);
        /// <summary> Determines if two <see cref="RouteMapMatchCondition"/> values are the same. </summary>
        public static bool operator ==(RouteMapMatchCondition left, RouteMapMatchCondition right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RouteMapMatchCondition"/> values are not the same. </summary>
        public static bool operator !=(RouteMapMatchCondition left, RouteMapMatchCondition right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RouteMapMatchCondition"/>. </summary>
        public static implicit operator RouteMapMatchCondition(string value) => new RouteMapMatchCondition(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RouteMapMatchCondition other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RouteMapMatchCondition other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
