// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> A matching criteria which matches routes based on route prefix, community, and AS path. </summary>
    public partial class RouteCriterion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RouteCriterion"/>. </summary>
        public RouteCriterion()
        {
            RoutePrefix = new ChangeTrackingList<string>();
            Community = new ChangeTrackingList<string>();
            AsPath = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="RouteCriterion"/>. </summary>
        /// <param name="routePrefix"> List of route prefixes which this criteria matches. </param>
        /// <param name="community"> List of BGP communities which this criteria matches. </param>
        /// <param name="asPath"> List of AS paths which this criteria matches. </param>
        /// <param name="matchCondition"> Match condition to apply RouteMap rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RouteCriterion(IList<string> routePrefix, IList<string> community, IList<string> asPath, RouteMapMatchCondition? matchCondition, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RoutePrefix = routePrefix;
            Community = community;
            AsPath = asPath;
            MatchCondition = matchCondition;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of route prefixes which this criteria matches. </summary>
        public IList<string> RoutePrefix { get; }
        /// <summary> List of BGP communities which this criteria matches. </summary>
        public IList<string> Community { get; }
        /// <summary> List of AS paths which this criteria matches. </summary>
        public IList<string> AsPath { get; }
        /// <summary> Match condition to apply RouteMap rules. </summary>
        public RouteMapMatchCondition? MatchCondition { get; set; }
    }
}
