// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> A collective group of information about the record set information. </summary>
    public partial class RecordSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecordSet"/>. </summary>
        internal RecordSet()
        {
            IPAddresses = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="RecordSet"/>. </summary>
        /// <param name="recordType"> Resource record type. </param>
        /// <param name="recordSetName"> Recordset name. </param>
        /// <param name="fqdn"> Fqdn that resolves to private endpoint ip address. </param>
        /// <param name="provisioningState"> The provisioning state of the recordset. </param>
        /// <param name="ttl"> Recordset time to live. </param>
        /// <param name="ipAddresses"> The private ip address of the private endpoint. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecordSet(string recordType, string recordSetName, string fqdn, NetworkProvisioningState? provisioningState, int? ttl, IReadOnlyList<string> ipAddresses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecordType = recordType;
            RecordSetName = recordSetName;
            Fqdn = fqdn;
            ProvisioningState = provisioningState;
            Ttl = ttl;
            IPAddresses = ipAddresses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource record type. </summary>
        public string RecordType { get; }
        /// <summary> Recordset name. </summary>
        public string RecordSetName { get; }
        /// <summary> Fqdn that resolves to private endpoint ip address. </summary>
        public string Fqdn { get; }
        /// <summary> The provisioning state of the recordset. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Recordset time to live. </summary>
        public int? Ttl { get; }
        /// <summary> The private ip address of the private endpoint. </summary>
        public IReadOnlyList<string> IPAddresses { get; }
    }
}
