// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Radius Server Settings. </summary>
    public partial class RadiusServer
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RadiusServer"/>. </summary>
        /// <param name="radiusServerAddress"> The address of this radius server. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="radiusServerAddress"/> is null. </exception>
        public RadiusServer(string radiusServerAddress)
        {
            Argument.AssertNotNull(radiusServerAddress, nameof(radiusServerAddress));

            RadiusServerAddress = radiusServerAddress;
        }

        /// <summary> Initializes a new instance of <see cref="RadiusServer"/>. </summary>
        /// <param name="radiusServerAddress"> The address of this radius server. </param>
        /// <param name="radiusServerScore"> The initial score assigned to this radius server. </param>
        /// <param name="radiusServerSecret"> The secret used for this radius server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RadiusServer(string radiusServerAddress, long? radiusServerScore, string radiusServerSecret, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RadiusServerAddress = radiusServerAddress;
            RadiusServerScore = radiusServerScore;
            RadiusServerSecret = radiusServerSecret;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RadiusServer"/> for deserialization. </summary>
        internal RadiusServer()
        {
        }

        /// <summary> The address of this radius server. </summary>
        public string RadiusServerAddress { get; set; }
        /// <summary> The initial score assigned to this radius server. </summary>
        public long? RadiusServerScore { get; set; }
        /// <summary> The secret used for this radius server. </summary>
        public string RadiusServerSecret { get; set; }
    }
}
