// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Response for GetPublicIpAddressDdosProtectionStatusOperation API service call. </summary>
    public partial class PublicIPDdosProtectionStatusResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PublicIPDdosProtectionStatusResult"/>. </summary>
        internal PublicIPDdosProtectionStatusResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PublicIPDdosProtectionStatusResult"/>. </summary>
        /// <param name="publicIPAddressId"> Public IP ARM resource ID. </param>
        /// <param name="publicIPAddress"> IP Address of the Public IP Resource. </param>
        /// <param name="isWorkloadProtected"> Value indicating whether the IP address is DDoS workload protected or not. </param>
        /// <param name="ddosProtectionPlanId"> DDoS protection plan Resource Id of a if IP address is protected through a plan. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PublicIPDdosProtectionStatusResult(ResourceIdentifier publicIPAddressId, IPAddress publicIPAddress, WorkloadProtectedFlag? isWorkloadProtected, ResourceIdentifier ddosProtectionPlanId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublicIPAddressId = publicIPAddressId;
            PublicIPAddress = publicIPAddress;
            IsWorkloadProtected = isWorkloadProtected;
            DdosProtectionPlanId = ddosProtectionPlanId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Public IP ARM resource ID. </summary>
        public ResourceIdentifier PublicIPAddressId { get; }
        /// <summary> IP Address of the Public IP Resource. </summary>
        public IPAddress PublicIPAddress { get; }
        /// <summary> Value indicating whether the IP address is DDoS workload protected or not. </summary>
        public WorkloadProtectedFlag? IsWorkloadProtected { get; }
        /// <summary> DDoS protection plan Resource Id of a if IP address is protected through a plan. </summary>
        public ResourceIdentifier DdosProtectionPlanId { get; }
    }
}
