// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> RNM supported protocol types. </summary>
    public readonly partial struct ProtocolType : IEquatable<ProtocolType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProtocolType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProtocolType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DoNotUseValue = "DoNotUse";
        private const string IcmpValue = "Icmp";
        private const string TcpValue = "Tcp";
        private const string UdpValue = "Udp";
        private const string GreValue = "Gre";
        private const string EspValue = "Esp";
        private const string AhValue = "Ah";
        private const string VxlanValue = "Vxlan";
        private const string AllValue = "All";

        /// <summary> DoNotUse. </summary>
        public static ProtocolType DoNotUse { get; } = new ProtocolType(DoNotUseValue);
        /// <summary> Icmp. </summary>
        public static ProtocolType Icmp { get; } = new ProtocolType(IcmpValue);
        /// <summary> Tcp. </summary>
        public static ProtocolType Tcp { get; } = new ProtocolType(TcpValue);
        /// <summary> Udp. </summary>
        public static ProtocolType Udp { get; } = new ProtocolType(UdpValue);
        /// <summary> Gre. </summary>
        public static ProtocolType Gre { get; } = new ProtocolType(GreValue);
        /// <summary> Esp. </summary>
        public static ProtocolType Esp { get; } = new ProtocolType(EspValue);
        /// <summary> Ah. </summary>
        public static ProtocolType Ah { get; } = new ProtocolType(AhValue);
        /// <summary> Vxlan. </summary>
        public static ProtocolType Vxlan { get; } = new ProtocolType(VxlanValue);
        /// <summary> All. </summary>
        public static ProtocolType All { get; } = new ProtocolType(AllValue);
        /// <summary> Determines if two <see cref="ProtocolType"/> values are the same. </summary>
        public static bool operator ==(ProtocolType left, ProtocolType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProtocolType"/> values are not the same. </summary>
        public static bool operator !=(ProtocolType left, ProtocolType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProtocolType"/>. </summary>
        public static implicit operator ProtocolType(string value) => new ProtocolType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProtocolType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProtocolType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
