// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Determines how new connections are handled by the load balancer when all backend instances are probed down. </summary>
    public readonly partial struct ProbeNoHealthyBackendsBehavior : IEquatable<ProbeNoHealthyBackendsBehavior>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProbeNoHealthyBackendsBehavior"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProbeNoHealthyBackendsBehavior(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllProbedDownValue = "AllProbedDown";
        private const string AllProbedUpValue = "AllProbedUp";

        /// <summary> No new flows will be sent to the backend pool. </summary>
        public static ProbeNoHealthyBackendsBehavior AllProbedDown { get; } = new ProbeNoHealthyBackendsBehavior(AllProbedDownValue);
        /// <summary> When all backend instances are probed down, incoming packets will be sent to all instances. </summary>
        public static ProbeNoHealthyBackendsBehavior AllProbedUp { get; } = new ProbeNoHealthyBackendsBehavior(AllProbedUpValue);
        /// <summary> Determines if two <see cref="ProbeNoHealthyBackendsBehavior"/> values are the same. </summary>
        public static bool operator ==(ProbeNoHealthyBackendsBehavior left, ProbeNoHealthyBackendsBehavior right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProbeNoHealthyBackendsBehavior"/> values are not the same. </summary>
        public static bool operator !=(ProbeNoHealthyBackendsBehavior left, ProbeNoHealthyBackendsBehavior right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProbeNoHealthyBackendsBehavior"/>. </summary>
        public static implicit operator ProbeNoHealthyBackendsBehavior(string value) => new ProbeNoHealthyBackendsBehavior(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProbeNoHealthyBackendsBehavior other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProbeNoHealthyBackendsBehavior other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
