// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The preferred routing gateway types. </summary>
    public readonly partial struct PreferredRoutingGateway : IEquatable<PreferredRoutingGateway>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PreferredRoutingGateway"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PreferredRoutingGateway(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExpressRouteValue = "ExpressRoute";
        private const string VpnGatewayValue = "VpnGateway";
        private const string NoneValue = "None";

        /// <summary> ExpressRoute. </summary>
        public static PreferredRoutingGateway ExpressRoute { get; } = new PreferredRoutingGateway(ExpressRouteValue);
        /// <summary> VpnGateway. </summary>
        public static PreferredRoutingGateway VpnGateway { get; } = new PreferredRoutingGateway(VpnGatewayValue);
        /// <summary> None. </summary>
        public static PreferredRoutingGateway None { get; } = new PreferredRoutingGateway(NoneValue);
        /// <summary> Determines if two <see cref="PreferredRoutingGateway"/> values are the same. </summary>
        public static bool operator ==(PreferredRoutingGateway left, PreferredRoutingGateway right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PreferredRoutingGateway"/> values are not the same. </summary>
        public static bool operator !=(PreferredRoutingGateway left, PreferredRoutingGateway right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PreferredRoutingGateway"/>. </summary>
        public static implicit operator PreferredRoutingGateway(string value) => new PreferredRoutingGateway(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PreferredRoutingGateway other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PreferredRoutingGateway other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
