// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The Pfs Groups used in IKE Phase 2 for new child SA. </summary>
    public readonly partial struct PfsGroup : IEquatable<PfsGroup>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PfsGroup"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PfsGroup(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string Pfs1Value = "PFS1";
        private const string Pfs2Value = "PFS2";
        private const string Pfs2048Value = "PFS2048";
        private const string Ecp256Value = "ECP256";
        private const string Ecp384Value = "ECP384";
        private const string Pfs24Value = "PFS24";
        private const string Pfs14Value = "PFS14";
        private const string PfsValue = "PFSMM";

        /// <summary> None. </summary>
        public static PfsGroup None { get; } = new PfsGroup(NoneValue);
        /// <summary> PFS1. </summary>
        public static PfsGroup Pfs1 { get; } = new PfsGroup(Pfs1Value);
        /// <summary> PFS2. </summary>
        public static PfsGroup Pfs2 { get; } = new PfsGroup(Pfs2Value);
        /// <summary> PFS2048. </summary>
        public static PfsGroup Pfs2048 { get; } = new PfsGroup(Pfs2048Value);
        /// <summary> ECP256. </summary>
        public static PfsGroup Ecp256 { get; } = new PfsGroup(Ecp256Value);
        /// <summary> ECP384. </summary>
        public static PfsGroup Ecp384 { get; } = new PfsGroup(Ecp384Value);
        /// <summary> PFS24. </summary>
        public static PfsGroup Pfs24 { get; } = new PfsGroup(Pfs24Value);
        /// <summary> PFS14. </summary>
        public static PfsGroup Pfs14 { get; } = new PfsGroup(Pfs14Value);
        /// <summary> PFSMM. </summary>
        public static PfsGroup Pfs { get; } = new PfsGroup(PfsValue);
        /// <summary> Determines if two <see cref="PfsGroup"/> values are the same. </summary>
        public static bool operator ==(PfsGroup left, PfsGroup right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PfsGroup"/> values are not the same. </summary>
        public static bool operator !=(PfsGroup left, PfsGroup right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PfsGroup"/>. </summary>
        public static implicit operator PfsGroup(string value) => new PfsGroup(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PfsGroup other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PfsGroup other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
