// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Protocol to be filtered on. </summary>
    public readonly partial struct PcProtocol : IEquatable<PcProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PcProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PcProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string UdpValue = "UDP";
        private const string AnyValue = "Any";

        /// <summary> TCP. </summary>
        public static PcProtocol Tcp { get; } = new PcProtocol(TcpValue);
        /// <summary> UDP. </summary>
        public static PcProtocol Udp { get; } = new PcProtocol(UdpValue);
        /// <summary> Any. </summary>
        public static PcProtocol Any { get; } = new PcProtocol(AnyValue);
        /// <summary> Determines if two <see cref="PcProtocol"/> values are the same. </summary>
        public static bool operator ==(PcProtocol left, PcProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PcProtocol"/> values are not the same. </summary>
        public static bool operator !=(PcProtocol left, PcProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PcProtocol"/>. </summary>
        public static implicit operator PcProtocol(string value) => new PcProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PcProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PcProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
