// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Properties of the partner managed resource. </summary>
    public partial class PartnerManagedResourceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerManagedResourceProperties"/>. </summary>
        public PartnerManagedResourceProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartnerManagedResourceProperties"/>. </summary>
        /// <param name="id"> The partner managed resource id. </param>
        /// <param name="internalLoadBalancerId"> The partner managed ILB resource id. </param>
        /// <param name="standardLoadBalancerId"> The partner managed SLB resource id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerManagedResourceProperties(ResourceIdentifier id, ResourceIdentifier internalLoadBalancerId, ResourceIdentifier standardLoadBalancerId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            InternalLoadBalancerId = internalLoadBalancerId;
            StandardLoadBalancerId = standardLoadBalancerId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The partner managed resource id. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> The partner managed ILB resource id. </summary>
        public ResourceIdentifier InternalLoadBalancerId { get; }
        /// <summary> The partner managed SLB resource id. </summary>
        public ResourceIdentifier StandardLoadBalancerId { get; }
    }
}
