// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Network.Models
{
    internal static partial class PacketCaptureTargetTypeExtensions
    {
        public static string ToSerialString(this PacketCaptureTargetType value) => value switch
        {
            PacketCaptureTargetType.AzureVm => "AzureVM",
            PacketCaptureTargetType.AzureVmss => "AzureVMSS",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PacketCaptureTargetType value.")
        };

        public static PacketCaptureTargetType ToPacketCaptureTargetType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureVM")) return PacketCaptureTargetType.AzureVm;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureVMSS")) return PacketCaptureTargetType.AzureVmss;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown PacketCaptureTargetType value.");
        }
    }
}
