// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The storage location for a packet capture session. </summary>
    public partial class PacketCaptureStorageLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PacketCaptureStorageLocation"/>. </summary>
        public PacketCaptureStorageLocation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PacketCaptureStorageLocation"/>. </summary>
        /// <param name="storageId"> The ID of the storage account to save the packet capture session. Required if no localPath or filePath is provided. </param>
        /// <param name="storagePath"> The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture. </param>
        /// <param name="filePath"> This path is invalid if 'Continuous Capture' is provided with 'true' or 'false'. A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional. </param>
        /// <param name="localPath"> This path is valid if 'Continuous Capture' is provided with 'true' or 'false' and required if no storage ID is provided, otherwise optional. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PacketCaptureStorageLocation(ResourceIdentifier storageId, string storagePath, string filePath, string localPath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageId = storageId;
            StoragePath = storagePath;
            FilePath = filePath;
            LocalPath = localPath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ID of the storage account to save the packet capture session. Required if no localPath or filePath is provided. </summary>
        public ResourceIdentifier StorageId { get; set; }
        /// <summary> The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture. </summary>
        public string StoragePath { get; set; }
        /// <summary> This path is invalid if 'Continuous Capture' is provided with 'true' or 'false'. A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional. </summary>
        public string FilePath { get; set; }
        /// <summary> This path is valid if 'Continuous Capture' is provided with 'true' or 'false' and required if no storage ID is provided, otherwise optional. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. </summary>
        public string LocalPath { get; set; }
    }
}
