// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The storage location for a packet capture session. </summary>
    public partial class PacketCaptureSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PacketCaptureSettings"/>. </summary>
        public PacketCaptureSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PacketCaptureSettings"/>. </summary>
        /// <param name="fileCount"> Number of file count. Default value of count is 10 and maximum number is 10000. </param>
        /// <param name="fileSizeInBytes"> Number of bytes captured per packet. Default value in bytes 104857600 (100MB) and maximum in bytes 4294967295 (4GB). </param>
        /// <param name="sessionTimeLimitInSeconds"> Maximum duration of the capture session in seconds is 604800s (7 days) for a file. Default value in second 86400s (1 day). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PacketCaptureSettings(int? fileCount, long? fileSizeInBytes, int? sessionTimeLimitInSeconds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FileCount = fileCount;
            FileSizeInBytes = fileSizeInBytes;
            SessionTimeLimitInSeconds = sessionTimeLimitInSeconds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Number of file count. Default value of count is 10 and maximum number is 10000. </summary>
        public int? FileCount { get; set; }
        /// <summary> Number of bytes captured per packet. Default value in bytes 104857600 (100MB) and maximum in bytes 4294967295 (4GB). </summary>
        public long? FileSizeInBytes { get; set; }
        /// <summary> Maximum duration of the capture session in seconds is 604800s (7 days) for a file. Default value in second 86400s (1 day). </summary>
        public int? SessionTimeLimitInSeconds { get; set; }
    }
}
