// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class PacketCaptureFilter : IUtf8JsonSerializable, IJsonModel<PacketCaptureFilter>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PacketCaptureFilter>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PacketCaptureFilter>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCaptureFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PacketCaptureFilter)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Protocol))
            {
                writer.WritePropertyName("protocol"u8);
                writer.WriteStringValue(Protocol.Value.ToString());
            }
            if (Optional.IsDefined(LocalIPAddress))
            {
                writer.WritePropertyName("localIPAddress"u8);
                writer.WriteStringValue(LocalIPAddress);
            }
            if (Optional.IsDefined(RemoteIPAddress))
            {
                writer.WritePropertyName("remoteIPAddress"u8);
                writer.WriteStringValue(RemoteIPAddress);
            }
            if (Optional.IsDefined(LocalPort))
            {
                writer.WritePropertyName("localPort"u8);
                writer.WriteStringValue(LocalPort);
            }
            if (Optional.IsDefined(RemotePort))
            {
                writer.WritePropertyName("remotePort"u8);
                writer.WriteStringValue(RemotePort);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PacketCaptureFilter IJsonModel<PacketCaptureFilter>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCaptureFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PacketCaptureFilter)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePacketCaptureFilter(document.RootElement, options);
        }

        internal static PacketCaptureFilter DeserializePacketCaptureFilter(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PcProtocol? protocol = default;
            string localIPAddress = default;
            string remoteIPAddress = default;
            string localPort = default;
            string remotePort = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("protocol"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    protocol = new PcProtocol(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("localIPAddress"u8))
                {
                    localIPAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("remoteIPAddress"u8))
                {
                    remoteIPAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("localPort"u8))
                {
                    localPort = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("remotePort"u8))
                {
                    remotePort = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PacketCaptureFilter(
                protocol,
                localIPAddress,
                remoteIPAddress,
                localPort,
                remotePort,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PacketCaptureFilter>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCaptureFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PacketCaptureFilter)} does not support writing '{options.Format}' format.");
            }
        }

        PacketCaptureFilter IPersistableModel<PacketCaptureFilter>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PacketCaptureFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePacketCaptureFilter(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PacketCaptureFilter)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PacketCaptureFilter>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
