// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Vpn Client Parameters for package generation. </summary>
    public partial class P2SVpnProfileContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="P2SVpnProfileContent"/>. </summary>
        public P2SVpnProfileContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="P2SVpnProfileContent"/>. </summary>
        /// <param name="authenticationMethod"> VPN client authentication method. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal P2SVpnProfileContent(NetworkAuthenticationMethod? authenticationMethod, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthenticationMethod = authenticationMethod;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> VPN client authentication method. </summary>
        public NetworkAuthenticationMethod? AuthenticationMethod { get; set; }
    }
}
