// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> List of p2s vpn connections to be disconnected. </summary>
    public partial class P2SVpnConnectionRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="P2SVpnConnectionRequest"/>. </summary>
        public P2SVpnConnectionRequest()
        {
            VpnConnectionIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="P2SVpnConnectionRequest"/>. </summary>
        /// <param name="vpnConnectionIds"> List of p2s vpn connection Ids. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal P2SVpnConnectionRequest(IList<string> vpnConnectionIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VpnConnectionIds = vpnConnectionIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of p2s vpn connection Ids. </summary>
        public IList<string> VpnConnectionIds { get; }
    }
}
