// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The variable to be excluded. </summary>
    public readonly partial struct OwaspCrsExclusionEntryMatchVariable : IEquatable<OwaspCrsExclusionEntryMatchVariable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OwaspCrsExclusionEntryMatchVariable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OwaspCrsExclusionEntryMatchVariable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequestHeaderNamesValue = "RequestHeaderNames";
        private const string RequestCookieNamesValue = "RequestCookieNames";
        private const string RequestArgNamesValue = "RequestArgNames";
        private const string RequestHeaderKeysValue = "RequestHeaderKeys";
        private const string RequestHeaderValuesValue = "RequestHeaderValues";
        private const string RequestCookieKeysValue = "RequestCookieKeys";
        private const string RequestCookieValuesValue = "RequestCookieValues";
        private const string RequestArgKeysValue = "RequestArgKeys";
        private const string RequestArgValuesValue = "RequestArgValues";

        /// <summary> RequestHeaderNames. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestHeaderNames { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestHeaderNamesValue);
        /// <summary> RequestCookieNames. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestCookieNames { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestCookieNamesValue);
        /// <summary> RequestArgNames. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestArgNames { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestArgNamesValue);
        /// <summary> RequestHeaderKeys. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestHeaderKeys { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestHeaderKeysValue);
        /// <summary> RequestHeaderValues. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestHeaderValues { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestHeaderValuesValue);
        /// <summary> RequestCookieKeys. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestCookieKeys { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestCookieKeysValue);
        /// <summary> RequestCookieValues. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestCookieValues { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestCookieValuesValue);
        /// <summary> RequestArgKeys. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestArgKeys { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestArgKeysValue);
        /// <summary> RequestArgValues. </summary>
        public static OwaspCrsExclusionEntryMatchVariable RequestArgValues { get; } = new OwaspCrsExclusionEntryMatchVariable(RequestArgValuesValue);
        /// <summary> Determines if two <see cref="OwaspCrsExclusionEntryMatchVariable"/> values are the same. </summary>
        public static bool operator ==(OwaspCrsExclusionEntryMatchVariable left, OwaspCrsExclusionEntryMatchVariable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OwaspCrsExclusionEntryMatchVariable"/> values are not the same. </summary>
        public static bool operator !=(OwaspCrsExclusionEntryMatchVariable left, OwaspCrsExclusionEntryMatchVariable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OwaspCrsExclusionEntryMatchVariable"/>. </summary>
        public static implicit operator OwaspCrsExclusionEntryMatchVariable(string value) => new OwaspCrsExclusionEntryMatchVariable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OwaspCrsExclusionEntryMatchVariable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OwaspCrsExclusionEntryMatchVariable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
