// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The office traffic category. </summary>
    public readonly partial struct OfficeTrafficCategory : IEquatable<OfficeTrafficCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OfficeTrafficCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OfficeTrafficCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OptimizeValue = "Optimize";
        private const string OptimizeAndAllowValue = "OptimizeAndAllow";
        private const string AllValue = "All";
        private const string NoneValue = "None";

        /// <summary> Optimize. </summary>
        public static OfficeTrafficCategory Optimize { get; } = new OfficeTrafficCategory(OptimizeValue);
        /// <summary> OptimizeAndAllow. </summary>
        public static OfficeTrafficCategory OptimizeAndAllow { get; } = new OfficeTrafficCategory(OptimizeAndAllowValue);
        /// <summary> All. </summary>
        public static OfficeTrafficCategory All { get; } = new OfficeTrafficCategory(AllValue);
        /// <summary> None. </summary>
        public static OfficeTrafficCategory None { get; } = new OfficeTrafficCategory(NoneValue);
        /// <summary> Determines if two <see cref="OfficeTrafficCategory"/> values are the same. </summary>
        public static bool operator ==(OfficeTrafficCategory left, OfficeTrafficCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OfficeTrafficCategory"/> values are not the same. </summary>
        public static bool operator !=(OfficeTrafficCategory left, OfficeTrafficCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OfficeTrafficCategory"/>. </summary>
        public static implicit operator OfficeTrafficCategory(string value) => new OfficeTrafficCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OfficeTrafficCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OfficeTrafficCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
