// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> NIC type. This should be either PublicNic or PrivateNic. </summary>
    public readonly partial struct NicTypeInRequest : IEquatable<NicTypeInRequest>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NicTypeInRequest"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NicTypeInRequest(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PublicNicValue = "PublicNic";
        private const string PrivateNicValue = "PrivateNic";

        /// <summary> PublicNic. </summary>
        public static NicTypeInRequest PublicNic { get; } = new NicTypeInRequest(PublicNicValue);
        /// <summary> PrivateNic. </summary>
        public static NicTypeInRequest PrivateNic { get; } = new NicTypeInRequest(PrivateNicValue);
        /// <summary> Determines if two <see cref="NicTypeInRequest"/> values are the same. </summary>
        public static bool operator ==(NicTypeInRequest left, NicTypeInRequest right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NicTypeInRequest"/> values are not the same. </summary>
        public static bool operator !=(NicTypeInRequest left, NicTypeInRequest right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NicTypeInRequest"/>. </summary>
        public static implicit operator NicTypeInRequest(string value) => new NicTypeInRequest(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NicTypeInRequest other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NicTypeInRequest other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
