// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Next hop type. </summary>
    public readonly partial struct NextHopType : IEquatable<NextHopType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NextHopType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NextHopType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InternetValue = "Internet";
        private const string VirtualApplianceValue = "VirtualAppliance";
        private const string VirtualNetworkGatewayValue = "VirtualNetworkGateway";
        private const string VnetLocalValue = "VnetLocal";
        private const string HyperNetGatewayValue = "HyperNetGateway";
        private const string NoneValue = "None";

        /// <summary> Internet. </summary>
        public static NextHopType Internet { get; } = new NextHopType(InternetValue);
        /// <summary> VirtualAppliance. </summary>
        public static NextHopType VirtualAppliance { get; } = new NextHopType(VirtualApplianceValue);
        /// <summary> VirtualNetworkGateway. </summary>
        public static NextHopType VirtualNetworkGateway { get; } = new NextHopType(VirtualNetworkGatewayValue);
        /// <summary> VnetLocal. </summary>
        public static NextHopType VnetLocal { get; } = new NextHopType(VnetLocalValue);
        /// <summary> HyperNetGateway. </summary>
        public static NextHopType HyperNetGateway { get; } = new NextHopType(HyperNetGatewayValue);
        /// <summary> None. </summary>
        public static NextHopType None { get; } = new NextHopType(NoneValue);
        /// <summary> Determines if two <see cref="NextHopType"/> values are the same. </summary>
        public static bool operator ==(NextHopType left, NextHopType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NextHopType"/> values are not the same. </summary>
        public static bool operator !=(NextHopType left, NextHopType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NextHopType"/>. </summary>
        public static implicit operator NextHopType(string value) => new NextHopType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NextHopType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NextHopType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
