// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The information about next hop from the specified VM. </summary>
    public partial class NextHopResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NextHopResult"/>. </summary>
        internal NextHopResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NextHopResult"/>. </summary>
        /// <param name="nextHopType"> Next hop type. </param>
        /// <param name="nextHopIPAddress"> Next hop IP Address. </param>
        /// <param name="routeTableId"> The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NextHopResult(NextHopType? nextHopType, string nextHopIPAddress, ResourceIdentifier routeTableId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NextHopType = nextHopType;
            NextHopIPAddress = nextHopIPAddress;
            RouteTableId = routeTableId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Next hop type. </summary>
        public NextHopType? NextHopType { get; }
        /// <summary> Next hop IP Address. </summary>
        public string NextHopIPAddress { get; }
        /// <summary> The resource identifier for the route table associated with the route being returned. If the route being returned does not correspond to any user created routes then this field will be the string 'System Route'. </summary>
        public ResourceIdentifier RouteTableId { get; }
    }
}
