// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network protocol. </summary>
    public readonly partial struct NetworkWatcherProtocol : IEquatable<NetworkWatcherProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkWatcherProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkWatcherProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "Tcp";
        private const string HttpValue = "Http";
        private const string HttpsValue = "Https";
        private const string IcmpValue = "Icmp";

        /// <summary> Tcp. </summary>
        public static NetworkWatcherProtocol Tcp { get; } = new NetworkWatcherProtocol(TcpValue);
        /// <summary> Http. </summary>
        public static NetworkWatcherProtocol Http { get; } = new NetworkWatcherProtocol(HttpValue);
        /// <summary> Https. </summary>
        public static NetworkWatcherProtocol Https { get; } = new NetworkWatcherProtocol(HttpsValue);
        /// <summary> Icmp. </summary>
        public static NetworkWatcherProtocol Icmp { get; } = new NetworkWatcherProtocol(IcmpValue);
        /// <summary> Determines if two <see cref="NetworkWatcherProtocol"/> values are the same. </summary>
        public static bool operator ==(NetworkWatcherProtocol left, NetworkWatcherProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkWatcherProtocol"/> values are not the same. </summary>
        public static bool operator !=(NetworkWatcherProtocol left, NetworkWatcherProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkWatcherProtocol"/>. </summary>
        public static implicit operator NetworkWatcherProtocol(string value) => new NetworkWatcherProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkWatcherProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkWatcherProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
