// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> HTTP method. </summary>
    public readonly partial struct NetworkWatcherHttpMethod : IEquatable<NetworkWatcherHttpMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkWatcherHttpMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkWatcherHttpMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GetValue = "Get";

        /// <summary> Get. </summary>
        public static NetworkWatcherHttpMethod Get { get; } = new NetworkWatcherHttpMethod(GetValue);
        /// <summary> Determines if two <see cref="NetworkWatcherHttpMethod"/> values are the same. </summary>
        public static bool operator ==(NetworkWatcherHttpMethod left, NetworkWatcherHttpMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkWatcherHttpMethod"/> values are not the same. </summary>
        public static bool operator !=(NetworkWatcherHttpMethod left, NetworkWatcherHttpMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkWatcherHttpMethod"/>. </summary>
        public static implicit operator NetworkWatcherHttpMethod(string value) => new NetworkWatcherHttpMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkWatcherHttpMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkWatcherHttpMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
