// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network Profile containing configurations for Public and Private NIC. </summary>
    internal partial class NetworkVirtualAppliancePropertiesFormatNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkVirtualAppliancePropertiesFormatNetworkProfile"/>. </summary>
        public NetworkVirtualAppliancePropertiesFormatNetworkProfile()
        {
            NetworkInterfaceConfigurations = new ChangeTrackingList<VirtualApplianceNetworkInterfaceConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkVirtualAppliancePropertiesFormatNetworkProfile"/>. </summary>
        /// <param name="networkInterfaceConfigurations"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkVirtualAppliancePropertiesFormatNetworkProfile(IList<VirtualApplianceNetworkInterfaceConfiguration> networkInterfaceConfigurations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkInterfaceConfigurations = networkInterfaceConfigurations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the network interface configurations. </summary>
        public IList<VirtualApplianceNetworkInterfaceConfiguration> NetworkInterfaceConfigurations { get; }
    }
}
