// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> An enum describing the unit of measurement. </summary>
    public readonly partial struct NetworkUsageUnit : IEquatable<NetworkUsageUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkUsageUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkUsageUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";

        /// <summary> Count. </summary>
        public static NetworkUsageUnit Count { get; } = new NetworkUsageUnit(CountValue);
        /// <summary> Determines if two <see cref="NetworkUsageUnit"/> values are the same. </summary>
        public static bool operator ==(NetworkUsageUnit left, NetworkUsageUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkUsageUnit"/> values are not the same. </summary>
        public static bool operator !=(NetworkUsageUnit left, NetworkUsageUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkUsageUnit"/>. </summary>
        public static implicit operator NetworkUsageUnit(string value) => new NetworkUsageUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkUsageUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkUsageUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
