// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Topology of the specified resource group. </summary>
    public partial class NetworkTopology
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkTopology"/>. </summary>
        internal NetworkTopology()
        {
            Resources = new ChangeTrackingList<TopologyResourceInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkTopology"/>. </summary>
        /// <param name="id"> GUID representing the operation id. </param>
        /// <param name="createdOn"> The datetime when the topology was initially created for the resource group. </param>
        /// <param name="lastModified"> The datetime when the topology was last modified. </param>
        /// <param name="resources"> A list of topology resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkTopology(string id, DateTimeOffset? createdOn, DateTimeOffset? lastModified, IReadOnlyList<TopologyResourceInfo> resources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            CreatedOn = createdOn;
            LastModified = lastModified;
            Resources = resources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> GUID representing the operation id. </summary>
        public string Id { get; }
        /// <summary> The datetime when the topology was initially created for the resource group. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The datetime when the topology was last modified. </summary>
        public DateTimeOffset? LastModified { get; }
        /// <summary> A list of topology resources. </summary>
        public IReadOnlyList<TopologyResourceInfo> Resources { get; }
    }
}
