// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network Manager Deployment Status Parameter. </summary>
    public partial class NetworkManagerDeploymentStatusContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkManagerDeploymentStatusContent"/>. </summary>
        public NetworkManagerDeploymentStatusContent()
        {
            Regions = new ChangeTrackingList<string>();
            DeploymentTypes = new ChangeTrackingList<NetworkConfigurationDeploymentType>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkManagerDeploymentStatusContent"/>. </summary>
        /// <param name="regions"> List of locations. </param>
        /// <param name="deploymentTypes"> List of deployment types. </param>
        /// <param name="skipToken"> Continuation token for pagination, capturing the next page size and offset, as well as the context of the query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkManagerDeploymentStatusContent(IList<string> regions, IList<NetworkConfigurationDeploymentType> deploymentTypes, string skipToken, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Regions = regions;
            DeploymentTypes = deploymentTypes;
            SkipToken = skipToken;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of locations. </summary>
        public IList<string> Regions { get; }
        /// <summary> List of deployment types. </summary>
        public IList<NetworkConfigurationDeploymentType> DeploymentTypes { get; }
        /// <summary> Continuation token for pagination, capturing the next page size and offset, as well as the context of the query. </summary>
        public string SkipToken { get; set; }
    }
}
