// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Deployment Status. </summary>
    public readonly partial struct NetworkManagerDeploymentState : IEquatable<NetworkManagerDeploymentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkManagerDeploymentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkManagerDeploymentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string DeployingValue = "Deploying";
        private const string DeployedValue = "Deployed";
        private const string FailedValue = "Failed";

        /// <summary> NotStarted. </summary>
        public static NetworkManagerDeploymentState NotStarted { get; } = new NetworkManagerDeploymentState(NotStartedValue);
        /// <summary> Deploying. </summary>
        public static NetworkManagerDeploymentState Deploying { get; } = new NetworkManagerDeploymentState(DeployingValue);
        /// <summary> Deployed. </summary>
        public static NetworkManagerDeploymentState Deployed { get; } = new NetworkManagerDeploymentState(DeployedValue);
        /// <summary> Failed. </summary>
        public static NetworkManagerDeploymentState Failed { get; } = new NetworkManagerDeploymentState(FailedValue);
        /// <summary> Determines if two <see cref="NetworkManagerDeploymentState"/> values are the same. </summary>
        public static bool operator ==(NetworkManagerDeploymentState left, NetworkManagerDeploymentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkManagerDeploymentState"/> values are not the same. </summary>
        public static bool operator !=(NetworkManagerDeploymentState left, NetworkManagerDeploymentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkManagerDeploymentState"/>. </summary>
        public static implicit operator NetworkManagerDeploymentState(string value) => new NetworkManagerDeploymentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkManagerDeploymentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkManagerDeploymentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
