// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Migration phase of Network Interface resource. </summary>
    public readonly partial struct NetworkInterfaceMigrationPhase : IEquatable<NetworkInterfaceMigrationPhase>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkInterfaceMigrationPhase"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkInterfaceMigrationPhase(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PrepareValue = "Prepare";
        private const string CommitValue = "Commit";
        private const string AbortValue = "Abort";
        private const string CommittedValue = "Committed";

        /// <summary> None. </summary>
        public static NetworkInterfaceMigrationPhase None { get; } = new NetworkInterfaceMigrationPhase(NoneValue);
        /// <summary> Prepare. </summary>
        public static NetworkInterfaceMigrationPhase Prepare { get; } = new NetworkInterfaceMigrationPhase(PrepareValue);
        /// <summary> Commit. </summary>
        public static NetworkInterfaceMigrationPhase Commit { get; } = new NetworkInterfaceMigrationPhase(CommitValue);
        /// <summary> Abort. </summary>
        public static NetworkInterfaceMigrationPhase Abort { get; } = new NetworkInterfaceMigrationPhase(AbortValue);
        /// <summary> Committed. </summary>
        public static NetworkInterfaceMigrationPhase Committed { get; } = new NetworkInterfaceMigrationPhase(CommittedValue);
        /// <summary> Determines if two <see cref="NetworkInterfaceMigrationPhase"/> values are the same. </summary>
        public static bool operator ==(NetworkInterfaceMigrationPhase left, NetworkInterfaceMigrationPhase right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkInterfaceMigrationPhase"/> values are not the same. </summary>
        public static bool operator !=(NetworkInterfaceMigrationPhase left, NetworkInterfaceMigrationPhase right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkInterfaceMigrationPhase"/>. </summary>
        public static implicit operator NetworkInterfaceMigrationPhase(string value) => new NetworkInterfaceMigrationPhase(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkInterfaceMigrationPhase other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkInterfaceMigrationPhase other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
