// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Auxiliary sku of Network Interface resource. </summary>
    public readonly partial struct NetworkInterfaceAuxiliarySku : IEquatable<NetworkInterfaceAuxiliarySku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkInterfaceAuxiliarySku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkInterfaceAuxiliarySku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string A1Value = "A1";
        private const string A2Value = "A2";
        private const string A4Value = "A4";
        private const string A8Value = "A8";

        /// <summary> None. </summary>
        public static NetworkInterfaceAuxiliarySku None { get; } = new NetworkInterfaceAuxiliarySku(NoneValue);
        /// <summary> A1. </summary>
        public static NetworkInterfaceAuxiliarySku A1 { get; } = new NetworkInterfaceAuxiliarySku(A1Value);
        /// <summary> A2. </summary>
        public static NetworkInterfaceAuxiliarySku A2 { get; } = new NetworkInterfaceAuxiliarySku(A2Value);
        /// <summary> A4. </summary>
        public static NetworkInterfaceAuxiliarySku A4 { get; } = new NetworkInterfaceAuxiliarySku(A4Value);
        /// <summary> A8. </summary>
        public static NetworkInterfaceAuxiliarySku A8 { get; } = new NetworkInterfaceAuxiliarySku(A8Value);
        /// <summary> Determines if two <see cref="NetworkInterfaceAuxiliarySku"/> values are the same. </summary>
        public static bool operator ==(NetworkInterfaceAuxiliarySku left, NetworkInterfaceAuxiliarySku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkInterfaceAuxiliarySku"/> values are not the same. </summary>
        public static bool operator !=(NetworkInterfaceAuxiliarySku left, NetworkInterfaceAuxiliarySku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkInterfaceAuxiliarySku"/>. </summary>
        public static implicit operator NetworkInterfaceAuxiliarySku(string value) => new NetworkInterfaceAuxiliarySku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkInterfaceAuxiliarySku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkInterfaceAuxiliarySku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
