// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Auxiliary mode of Network Interface resource. </summary>
    public readonly partial struct NetworkInterfaceAuxiliaryMode : IEquatable<NetworkInterfaceAuxiliaryMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkInterfaceAuxiliaryMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkInterfaceAuxiliaryMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string MaxConnectionsValue = "MaxConnections";
        private const string FloatingValue = "Floating";
        private const string AcceleratedConnectionsValue = "AcceleratedConnections";

        /// <summary> None. </summary>
        public static NetworkInterfaceAuxiliaryMode None { get; } = new NetworkInterfaceAuxiliaryMode(NoneValue);
        /// <summary> MaxConnections. </summary>
        public static NetworkInterfaceAuxiliaryMode MaxConnections { get; } = new NetworkInterfaceAuxiliaryMode(MaxConnectionsValue);
        /// <summary> Floating. </summary>
        public static NetworkInterfaceAuxiliaryMode Floating { get; } = new NetworkInterfaceAuxiliaryMode(FloatingValue);
        /// <summary> AcceleratedConnections. </summary>
        public static NetworkInterfaceAuxiliaryMode AcceleratedConnections { get; } = new NetworkInterfaceAuxiliaryMode(AcceleratedConnectionsValue);
        /// <summary> Determines if two <see cref="NetworkInterfaceAuxiliaryMode"/> values are the same. </summary>
        public static bool operator ==(NetworkInterfaceAuxiliaryMode left, NetworkInterfaceAuxiliaryMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkInterfaceAuxiliaryMode"/> values are not the same. </summary>
        public static bool operator !=(NetworkInterfaceAuxiliaryMode left, NetworkInterfaceAuxiliaryMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkInterfaceAuxiliaryMode"/>. </summary>
        public static implicit operator NetworkInterfaceAuxiliaryMode(string value) => new NetworkInterfaceAuxiliaryMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkInterfaceAuxiliaryMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkInterfaceAuxiliaryMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
