// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest. </summary>
    public partial class NetworkIntentPolicyConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkIntentPolicyConfiguration"/>. </summary>
        public NetworkIntentPolicyConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkIntentPolicyConfiguration"/>. </summary>
        /// <param name="networkIntentPolicyName"> The name of the Network Intent Policy for storing in target subscription. </param>
        /// <param name="sourceNetworkIntentPolicy"> Source network intent policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkIntentPolicyConfiguration(string networkIntentPolicyName, NetworkIntentPolicy sourceNetworkIntentPolicy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkIntentPolicyName = networkIntentPolicyName;
            SourceNetworkIntentPolicy = sourceNetworkIntentPolicy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the Network Intent Policy for storing in target subscription. </summary>
        public string NetworkIntentPolicyName { get; set; }
        /// <summary> Source network intent policy. </summary>
        public NetworkIntentPolicy SourceNetworkIntentPolicy { get; set; }
    }
}
