// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Network intent policy based services. </summary>
    public readonly partial struct NetworkIntentPolicyBasedService : IEquatable<NetworkIntentPolicyBasedService>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkIntentPolicyBasedService"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkIntentPolicyBasedService(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string AllValue = "All";
        private const string AllowRulesOnlyValue = "AllowRulesOnly";

        /// <summary> None. </summary>
        public static NetworkIntentPolicyBasedService None { get; } = new NetworkIntentPolicyBasedService(NoneValue);
        /// <summary> All. </summary>
        public static NetworkIntentPolicyBasedService All { get; } = new NetworkIntentPolicyBasedService(AllValue);
        /// <summary> AllowRulesOnly. </summary>
        public static NetworkIntentPolicyBasedService AllowRulesOnly { get; } = new NetworkIntentPolicyBasedService(AllowRulesOnlyValue);
        /// <summary> Determines if two <see cref="NetworkIntentPolicyBasedService"/> values are the same. </summary>
        public static bool operator ==(NetworkIntentPolicyBasedService left, NetworkIntentPolicyBasedService right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkIntentPolicyBasedService"/> values are not the same. </summary>
        public static bool operator !=(NetworkIntentPolicyBasedService left, NetworkIntentPolicyBasedService right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkIntentPolicyBasedService"/>. </summary>
        public static implicit operator NetworkIntentPolicyBasedService(string value) => new NetworkIntentPolicyBasedService(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkIntentPolicyBasedService other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkIntentPolicyBasedService other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
