// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> IP configuration profile child resource. </summary>
    public partial class NetworkIPConfigurationProfile : NetworkResourceData
    {
        /// <summary> Initializes a new instance of <see cref="NetworkIPConfigurationProfile"/>. </summary>
        public NetworkIPConfigurationProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkIPConfigurationProfile"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="subnet"> The reference to the subnet resource to create a container network interface ip configuration. </param>
        /// <param name="provisioningState"> The provisioning state of the IP configuration profile resource. </param>
        internal NetworkIPConfigurationProfile(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ETag? etag, SubnetData subnet, NetworkProvisioningState? provisioningState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            ETag = etag;
            Subnet = subnet;
            ProvisioningState = provisioningState;
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> The reference to the subnet resource to create a container network interface ip configuration. </summary>
        public SubnetData Subnet { get; set; }
        /// <summary> The provisioning state of the IP configuration profile resource. </summary>
        public NetworkProvisioningState? ProvisioningState { get; }
    }
}
