// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class NetworkIPConfigurationBgpPeeringAddress : IUtf8JsonSerializable, IJsonModel<NetworkIPConfigurationBgpPeeringAddress>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NetworkIPConfigurationBgpPeeringAddress>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NetworkIPConfigurationBgpPeeringAddress>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetworkIPConfigurationBgpPeeringAddress)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IPConfigurationId))
            {
                writer.WritePropertyName("ipconfigurationId"u8);
                writer.WriteStringValue(IPConfigurationId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DefaultBgpIPAddresses))
            {
                writer.WritePropertyName("defaultBgpIpAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in DefaultBgpIPAddresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CustomBgpIPAddresses))
            {
                writer.WritePropertyName("customBgpIpAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in CustomBgpIPAddresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(TunnelIPAddresses))
            {
                writer.WritePropertyName("tunnelIpAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in TunnelIPAddresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NetworkIPConfigurationBgpPeeringAddress IJsonModel<NetworkIPConfigurationBgpPeeringAddress>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NetworkIPConfigurationBgpPeeringAddress)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNetworkIPConfigurationBgpPeeringAddress(document.RootElement, options);
        }

        internal static NetworkIPConfigurationBgpPeeringAddress DeserializeNetworkIPConfigurationBgpPeeringAddress(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string ipconfigurationId = default;
            IReadOnlyList<string> defaultBgpIPAddresses = default;
            IList<string> customBgpIPAddresses = default;
            IReadOnlyList<string> tunnelIPAddresses = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ipconfigurationId"u8))
                {
                    ipconfigurationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("defaultBgpIpAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    defaultBgpIPAddresses = array;
                    continue;
                }
                if (property.NameEquals("customBgpIpAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    customBgpIPAddresses = array;
                    continue;
                }
                if (property.NameEquals("tunnelIpAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    tunnelIPAddresses = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NetworkIPConfigurationBgpPeeringAddress(ipconfigurationId, defaultBgpIPAddresses ?? new ChangeTrackingList<string>(), customBgpIPAddresses ?? new ChangeTrackingList<string>(), tunnelIPAddresses ?? new ChangeTrackingList<string>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NetworkIPConfigurationBgpPeeringAddress)} does not support writing '{options.Format}' format.");
            }
        }

        NetworkIPConfigurationBgpPeeringAddress IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNetworkIPConfigurationBgpPeeringAddress(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NetworkIPConfigurationBgpPeeringAddress)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NetworkIPConfigurationBgpPeeringAddress>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
