// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> IpAllocation type. </summary>
    public readonly partial struct NetworkIPAllocationType : IEquatable<NetworkIPAllocationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkIPAllocationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkIPAllocationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UndefinedValue = "Undefined";
        private const string HypernetValue = "Hypernet";

        /// <summary> Undefined. </summary>
        public static NetworkIPAllocationType Undefined { get; } = new NetworkIPAllocationType(UndefinedValue);
        /// <summary> Hypernet. </summary>
        public static NetworkIPAllocationType Hypernet { get; } = new NetworkIPAllocationType(HypernetValue);
        /// <summary> Determines if two <see cref="NetworkIPAllocationType"/> values are the same. </summary>
        public static bool operator ==(NetworkIPAllocationType left, NetworkIPAllocationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkIPAllocationType"/> values are not the same. </summary>
        public static bool operator !=(NetworkIPAllocationType left, NetworkIPAllocationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkIPAllocationType"/>. </summary>
        public static implicit operator NetworkIPAllocationType(string value) => new NetworkIPAllocationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkIPAllocationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkIPAllocationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
